#Palaeozoic jaw disparity project
##Written in R version 4.3.3 (2024-02-29 ucrt) -- "Angel Food Cake"

setwd("D:/Jaw_disparity_project/Jaw_disparity/SUPPLEMENTARY FILE 7 Code_R2/Code biomechanics")

Sys.setenv(LANGUAGE="en")
library(ape)
library(parallel)
library(doParallel)
library(paleotree)
library(phytools)
library(Claddis)
library(strap)
library(vegan)
library(geiger)
library(xlsx)
library(dispRity)
library(tidyverse)
library(dplyr)
library(tidyr)
library(calibrate)
library(zoo)
library(e1071)
library(fBasics)
library(car)
library(epm)

source("functions.txt") #Necessary to run SoV later, this is the sum of variances function from Hughes et al 2013 PNAS

#Read data
dat <- read.csv('Jaw_measurements.csv',header = T, row.names = 1, sep=';')
head(dat)
#skip to line 802 for PCA
#Boxplots####
dev.new()
par(mfrow=c(3,3), pin = c(3, 2))

#####Separate####
#Amniotes vs. non-amniotes
#H1 (= Hypothesis 1. H1-4 refer to the phylogenetic hypotheses concerning Amniota that are discussed in the main text.)

boxplot(dat$C1_AntMA~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H1_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Symphysis length")

#H2
boxplot(dat$C1_AntMA~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H2_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Symphysis length")

#H3
boxplot(dat$C1_AntMA~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H3_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Symphysis length")

#H4
boxplot(dat$C1_AntMA~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H4_A, col =c('darkgoldenrod','lightgoldenrod'),
        xlab="",ylab="Symphysis length")

#SynSaur

#H1
boxplot(dat$C1_AntMA~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H1_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Symphysis length")

#H2
boxplot(dat$C1_AntMA~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H2_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Symphysis length")

#H3
boxplot(dat$C1_AntMA~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H3_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Symphysis length")

#H4
boxplot(dat$C1_AntMA~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$H4_SynSaur, col =c('lightgoldenrod','chartreuse','deepskyblue'),
        xlab="",ylab="Symphysis length")

#Herbivores
boxplot(dat$C1_AntMA~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Anterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C3_OMA~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Opening Mechanical Advantage")
boxplot(dat$C4_MaxAR~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Maximum Aspect Ratio")
boxplot(dat$C5_AvgAR~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Average Aspect Ratio")
boxplot(dat$C6_ArtOff~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Articular Offset")
boxplot(dat$C7_Tlength~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Tooth row length")
boxplot(dat$C8_AddF~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Adductor fossa length")
boxplot(dat$C9_Symph~dat$Herb, col =c('darkolivegreen','firebrick'),
        xlab="",ylab="Symphysis length")

######Combined#####
#Amniote vs non-amniote & Diet
H1_A_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_1 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_2 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_3 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_4 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_5 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_6 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_7 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_8 <- rbind(H1_A_data, Herb_data)

H1_A_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H1_A), ]
H1_A_data$Group <- H1_A_data$H1_A
Herb_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$Herb), ]
Herb_data$Group <- Herb_data$Herb
H1_A_data$Group <- paste0("Amniote", H1_A_data$Group)
Herb_data$Group <- paste0("Herbivore", Herb_data$Group)
plot_data_9 <- rbind(H1_A_data, Herb_data)

# Figure 1
boxplot(C1_AntMA ~ Group, data = plot_data_1,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Anterior Mechanical Advantage",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C2_PostMA ~ Group, data = plot_data_2,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Posterior Mechanical Advantage",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C3_OMA ~ Group, data = plot_data_3,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Opening Mechanical Advantage",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C4_MaxAR ~ Group, data = plot_data_4,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Maximum Aspect Ratio",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C5_AvgAR ~ Group, data = plot_data_5,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Average Aspect Ratio",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C6_ArtOff ~ Group, data = plot_data_6,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Articular Offset",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C7_Tlength ~ Group, data = plot_data_7,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Tooth row length",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C8_AddF ~ Group, data = plot_data_8,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Adductor Fossa length",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))
boxplot(C9_Symph ~ Group, data = plot_data_9,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkolivegreen', 'firebrick'),
        ylab = "Symphysis length",
        xlab = "",
        names = c("Amn","Non-amn","Herb","Non-herb"))

#######Boxplots Amniote vs Non-amniote; H2, H3 and H4######

H2_A_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_1 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_2 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_3 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_4 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_5 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_6 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_7 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_8 <- rbind(H2_A_data, H3_A_data, H4_A_data)

H2_A_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H2_A), ]
H2_A_data$Group <- H2_A_data$H2_A
H3_A_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H3_A), ]
H3_A_data$Group <- H3_A_data$H3_A
H4_A_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H4_A), ]
H4_A_data$Group <- H4_A_data$H4_A
H2_A_data$Group <- paste0("H2_",H2_A_data$H2_A)
H3_A_data$Group <- paste0("H3_",H3_A_data$H3_A)
H4_A_data$Group <- paste0("H4_",H4_A_data$H4_A)
plot_data_9 <- rbind(H2_A_data, H3_A_data, H4_A_data)

#Supplementary Figure 1
boxplot(C1_AntMA ~ Group, data = plot_data_1,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Anterior Mechanical Advantage",
        xlab = "")
boxplot(C2_PostMA ~ Group, data = plot_data_2,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Posterior Mechanical Advantage",
        xlab = "")
boxplot(C3_OMA ~ Group, data = plot_data_3,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Opening Mechanical Advantage",
        xlab = "")
boxplot(C4_MaxAR ~ Group, data = plot_data_4,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Maximum Aspect Ratio",
        xlab = "")
boxplot(C5_AvgAR ~ Group, data = plot_data_5,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Average Aspect Ratio",
        xlab = "")
boxplot(C6_ArtOff ~ Group, data = plot_data_6,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Articular offset",
        xlab = "")
boxplot(C7_Tlength ~ Group, data = plot_data_7,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Tooth row length",
        xlab = "")
boxplot(C8_AddF ~ Group, data = plot_data_8,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Adductor Fossa length",
        xlab = "")
boxplot(C9_Symph ~ Group, data = plot_data_9,
        col = c('darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod', 'darkgoldenrod', 'lightgoldenrod'),
        ylab = "Symphysis length",
        xlab = "")

#Boxplots SynSaur; H2, H3 and H4

H2_SynSaur_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C1_AntMA) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_1 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C2_PostMA) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_2 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C3_OMA) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_3 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C4_MaxAR) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_4 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C5_AvgAR) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_5 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C6_ArtOff) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_6 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C7_Tlength) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_A
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_7 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C8_AddF) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_8 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

H2_SynSaur_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H2_SynSaur), ]
H2_SynSaur_data$Group <- H2_SynSaur_data$H2_SynSaur
H3_SynSaur_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H3_SynSaur), ]
H3_SynSaur_data$Group <- H3_SynSaur_data$H3_SynSaur
H4_SynSaur_data <- dat[!is.na(dat$C9_Symph) & !is.na(dat$H4_SynSaur), ]
H4_SynSaur_data$Group <- H4_SynSaur_data$H4_SynSaur
H2_SynSaur_data$Group <- paste0("H2_",H2_SynSaur_data$H2_SynSaur)
H3_SynSaur_data$Group <- paste0("H3_",H3_SynSaur_data$H3_SynSaur)
H4_SynSaur_data$Group <- paste0("H4_",H4_SynSaur_data$H4_SynSaur)
plot_data_9 <- rbind(H2_SynSaur_data, H3_SynSaur_data, H4_SynSaur_data)

#Supplementary Figure 2
boxplot(C1_AntMA ~ Group, data = plot_data_1,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Anterior Mechanical Advantage",
        xlab = "")
boxplot(C2_PostMA ~ Group, data = plot_data_2,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Posterior Mechanical Advantage",
        xlab = "")
boxplot(C3_OMA ~ Group, data = plot_data_3,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Opening Mechanical Advantage",
        xlab = "")
boxplot(C4_MaxAR ~ Group, data = plot_data_4,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Maximum Aspect Ratio",
        xlab = "")
boxplot(C5_AvgAR ~ Group, data = plot_data_5,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Average Aspect Ratio",
        xlab = "")
boxplot(C6_ArtOff ~ Group, data = plot_data_6,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Articular offset",
        xlab = "")
boxplot(C7_Tlength ~ Group, data = plot_data_7,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Tooth row length",
        xlab = "")
boxplot(C8_AddF ~ Group, data = plot_data_8,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Adductor Fossa length",
        xlab = "")
boxplot(C9_Symph ~ Group, data = plot_data_9,
        col = c('lightgoldenrod', 'chartreuse', 'deepskyblue', 'lightgoldenrod', 'chartreuse', 'deepskyblue','lightgoldenrod', 'chartreuse', 'deepskyblue'),
        ylab = "Symphysis length",
        xlab = "")

#Stats boxplots ####

#Regress Anterior MA with Posterior MA

plot(dat[,1:2],
     pch=21, cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$Amniote))])

amniote_data <- dat[dat$Amniote == "Amniote",]
anamniote_data <- dat[dat$Amniote == "Anamniote",]

model <- lm(dat$C2_PostMA ~ dat$C1_AntMA)
summary(model)

model_amniote <- lm(dat$C2_PostMA ~ dat$C1_AntMA, data = amniote_data)
model_anamniote <- lm(dat$C2_PostMA ~ dat$C1_AntMA, data = anamniote_data)

summary(model_amniote)
summary(model_anamniote)

#Regress AvgAR with MaxAR
plot(dat[,4:5],
     pch=21, cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$Amniote))])

amniote_data <- dat[dat$Amniote == "Amniote",]
anamniote_data <- dat[dat$Amniote == "Anamniote",]

model <- lm(dat$C5_AvgAR ~ dat$C4_MaxAR)
summary(model)

model_amniote <- lm(dat$C5_AvgAR ~ C4_MaxAR, data = amniote_data)
model_anamniote <- lm(dat$C5_AvgAR ~ C4_MaxAR, data = anamniote_data)

summary(model_amniote)
summary(model_anamniote)

#Amniote vs. non amniote

#H1
dat$H1_A <- as.factor(dat$H1_A)
leveneTest(dat$C1_AntMA, dat$H1_A)
leveneTest(dat$C2_PostMA, dat$H1_A)
leveneTest(dat$C3_OMA, dat$H1_A)
leveneTest(dat$C4_MaxAR, dat$H1_A)
leveneTest(dat$C5_AvgAR, dat$H1_A)
leveneTest(dat$C6_ArtOff, dat$H1_A)
leveneTest(dat$C7_Tlength, dat$H1_A)
leveneTest(dat$C8_AddF, dat$H1_A)
leveneTest(dat$C9_Symph, dat$H1_A)

pairwise.t.test(x=dat$C1_AntMA,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C3_OMA,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C4_MaxAR,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C5_AvgAR,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C6_ArtOff,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C7_Tlength,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H1_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H1_A,p.adjust.method = 'bonferroni')

#H2
dat$H2_A <- as.factor(dat$H2_A)
leveneTest(dat$C1_AntMA, dat$H2_A)
leveneTest(dat$C2_PostMA, dat$H2_A)
leveneTest(dat$C3_OMA, dat$H2_A)
leveneTest(dat$C4_MaxAR, dat$H2_A)
leveneTest(dat$C5_AvgAR, dat$H2_A)
leveneTest(dat$C6_ArtOff, dat$H2_A)
leveneTest(dat$C7_Tlength, dat$H2_A)
leveneTest(dat$C8_AddF, dat$H2_A)
leveneTest(dat$C9_Symph, dat$H2_A)

pairwise.t.test(x=dat$C1_AntMA,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C3_OMA,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C4_MaxAR,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C5_AvgAR,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C6_ArtOff,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C7_Tlength,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H2_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H2_A,p.adjust.method = 'bonferroni')

#H3
dat$H3_A <- as.factor(dat$H3_A)
leveneTest(dat$C1_AntMA, dat$H3_A)
leveneTest(dat$C2_PostMA, dat$H3_A)
leveneTest(dat$C3_OMA, dat$H3_A)
leveneTest(dat$C4_MaxAR, dat$H3_A)
leveneTest(dat$C5_AvgAR, dat$H3_A)
leveneTest(dat$C6_ArtOff, dat$H3_A)
leveneTest(dat$C7_Tlength, dat$H3_A)
leveneTest(dat$C8_AddF, dat$H3_A)
leveneTest(dat$C9_Symph, dat$H3_A)

pairwise.t.test(x=dat$C1_AntMA,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C3_OMA,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C4_MaxAR,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C5_AvgAR,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C6_ArtOff,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C7_Tlength,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H3_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H3_A,p.adjust.method = 'bonferroni')

#H4
dat$H4_A <- as.factor(dat$H4_A)
leveneTest(dat$C1_AntMA, dat$H4_A)
leveneTest(dat$C2_PostMA, dat$H4_A)
leveneTest(dat$C3_OMA, dat$H4_A)
leveneTest(dat$C4_MaxAR, dat$H4_A)
leveneTest(dat$C5_AvgAR, dat$H4_A)
leveneTest(dat$C6_ArtOff, dat$H4_A)
leveneTest(dat$C7_Tlength, dat$H4_A)
leveneTest(dat$C8_AddF, dat$H4_A)
leveneTest(dat$C9_Symph, dat$H4_A)

pairwise.t.test(x=dat$C1_AntMA,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C3_OMA,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C4_MaxAR,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C5_AvgAR,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C6_ArtOff,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C7_Tlength,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H4_A,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H4_A,p.adjust.method = 'bonferroni')

#Herbivores vs. non-herbivores
dat$Herb <- as.factor(dat$Herb)
leveneTest(dat$C1_AntMA, dat$Herb)
leveneTest(dat$C2_PostMA, dat$Herb)
leveneTest(dat$C3_OMA, dat$Herb)
leveneTest(dat$C4_MaxAR, dat$Herb)
leveneTest(dat$C5_AvgAR, dat$Herb)
leveneTest(dat$C6_ArtOff, dat$Herb)
leveneTest(dat$C7_Tlength, dat$Herb)
leveneTest(dat$C8_AddF, dat$Herb)
leveneTest(dat$C9_Symph, dat$Herb)

pairwise.t.test(x=dat$C1_AntMA,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C3_OMA,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C4_MaxAR,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C5_AvgAR,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C6_ArtOff,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C7_Tlength,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$Herb,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$Herb,p.adjust.method = 'bonferroni')

#PostMA w/o Therapsida
pairwise.t.test(x=dat$C2_PostMA,g = dat$H1_Therapsida,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H2_Therapsida,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H3_Therapsida,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C2_PostMA,g = dat$H4_Therapsida,p.adjust.method = 'bonferroni')

dev.off()
dev.new()
par(mfrow=c(2,2), pin = c(4, 3))

boxplot(dat$C2_PostMA~dat$H1_Therapsida, col =c('lightgoldenrod','chartreuse','navyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H2_Therapsida, col =c('lightgoldenrod','chartreuse','navyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H3_Therapsida, col =c('lightgoldenrod','chartreuse','navyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")
boxplot(dat$C2_PostMA~dat$H4_Therapsida, col =c('lightgoldenrod','chartreuse','navyblue'),
        xlab="",ylab="Posterior Mechanical Advantage")

pairwise.t.test(x=dat$C8_AddF,g = dat$H1_Therapsida,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H2_Therapsida,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H3_Therapsida,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C8_AddF,g = dat$H4_Therapsida,p.adjust.method = 'bonferroni')

#Exclude anomodonts

pairwise.t.test(x=dat$C9_Symph,g = dat$H1_Dicynodont,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H2_Dicynodont,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H3_Dicynodont,p.adjust.method = 'bonferroni')
pairwise.t.test(x=dat$C9_Symph,g = dat$H4_Dicynodont,p.adjust.method = 'bonferroni')

#Run PCA ####
#Z-transformation of characters
dat$C1_AntMA <- sapply(dat$C1_AntMA , function(x) (x-mean(dat$C1_AntMA))/sd(dat$C1_AntMA) )
dat$C2_PostMA <- sapply(dat$C2_PostMA , function(x) (x-mean(dat$C2_PostMA))/sd(dat$C2_PostMA) )
dat$C3_OMA <- sapply(dat$C3_OMA , function(x) (x-mean(dat$C3_OMA))/sd(dat$C3_OMA) )
dat$C4_MaxAR <- sapply(dat$C4_MaxAR , function(x) (x-mean(dat$C4_MaxAR))/sd(dat$C4_MaxAR) )
dat$C5_AvgAR <- sapply(dat$C5_AvgAR  , function(x) (x-mean(dat$C5_AvgAR ))/sd(dat$C5_AvgAR ) )
dat$C6_ArtOff <- sapply(dat$C6_ArtOff , function(x) (x-mean(dat$C6_ArtOff))/sd(dat$C6_ArtOff) )
dat$C7_Tlength <- sapply(dat$C7_Tlength , function(x) (x-mean(dat$C7_Tlength))/sd(dat$C7_Tlength) )
dat$C8_AddF <- sapply(dat$C8_AddF , function(x) (x-mean(dat$C8_AddF))/sd(dat$C8_AddF) )
dat$C9_Symph <- sapply(dat$C9_Symph , function(x) (x-mean(dat$C9_Symph))/sd(dat$C9_Symph) )

#PCA command
pca <- prcomp(dat[,1:9],scale. = T)
summary(pca)
eigenvalues <- pca$sdev^2
eigenvalues
eigenvector_coefficients<- pca$rotation
eigenvector_coefficients

write.xlsx(eigenvector_coefficients,"eigenvector.xlsx")
pca$x
pca_axes <- pca$x 
write.xlsx(pca_axes, "Functional_PCA.xlsx")

#biplots
dev.new()
biplot(pca,cex=c(0.6,0.8))
biplot(pca, choices=c(3,4), cex=0.6,0.8)

#PCA plots#####
dev.off()
dev.new()
par(mfrow=c(2,2), pin = c(4, 3))

#PC1-2

#Amniote
plot(pca$x[,1:2], 
     pch=c(22,21) [as.numeric(as.factor(dat$H1_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H1_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
     )
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H1_A)),ncol=1 )

plot(pca$x[,1:2], 
     pch=c(22,21) [as.numeric(as.factor(dat$H2_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H2_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H2_A)),ncol=1 )

plot(pca$x[,1:2], 
     pch=c(22,21) [as.numeric(as.factor(dat$H3_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H3_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H3_A)),ncol=1 )

plot(pca$x[,1:2], 
     pch=c(22,21) [as.numeric(as.factor(dat$H4_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H4_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H4_A)),ncol=1 )

#PC1-3
#Amniote
plot(pca$x[,1:3], 
     pch=c(22,21) [as.numeric(as.factor(dat$H1_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H1_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC3 (13.94%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H1_A)),ncol=1 )

plot(pca$x[,1:3], 
     pch=c(22,21) [as.numeric(as.factor(dat$H2_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H2_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC3 (13.94%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H2_A)),ncol=1 )

plot(pca$x[,1:3], 
     pch=c(22,21) [as.numeric(as.factor(dat$H3_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H3_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC3 (13.94%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H3_A)),ncol=1 )

plot(pca$x[,1:3], 
     pch=c(22,21) [as.numeric(as.factor(dat$H4_A))], cex=1.5,
     bg=c('darkgoldenrod','lightgoldenrod') [as.numeric(as.factor(dat$H4_A))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC3 (13.94%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkgoldenrod', 'lightgoldenrod'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H4_A)),ncol=1 )

#SynSaur

dev.off()
dev.new()
par(mfrow=c(2,2), pin = c(4, 3))

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H1_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H1_SynSaur))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright', pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H1_SynSaur)),ncol=2 )

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H2_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H2_SynSaur))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H2_SynSaur)),ncol=2 )

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H3_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H3_SynSaur))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H3_SynSaur)),ncol=2 )

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H4_SynSaur))], cex=1.5,
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H4_SynSaur))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('lightgoldenrod','chartreuse','deepskyblue'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$H4_SynSaur)),ncol=2 )

#Herb

dev.off()
dev.new()

plot(pca$x[,1:2], 
     pch=c(22,21) [as.numeric(as.factor(dat$Herb))], cex=1.5,
     bg=c('darkolivegreen','firebrick') [as.numeric(as.factor(dat$Herb))],
     xlab = ('PC1 (37.61%)'),
     ylab = ('PC2 (22.97%)')
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
legend('topright',pt.bg=c('darkolivegreen', 'firebrick'),pch=21,pt.cex=0.8,bty='n',
       legend=levels(as.factor(dat$Herb)),ncol=1 )

#Volume of morphospace occupation#####

set.seed(25)

#Amniota vs Anamniota
Amniote1 <- lapply ( sort(unique(dat$H1_A)), function(x) rownames(dat)[dat$H1_A==x]  )
names(Amniote1) <- sort(unique(dat$H1_A))

Amniote1 <- Amniote1[c('Amniote','Non-amniote')]

Amniote1_disparity <- custom.subsets(pca$x,group = Amniote1)
Amniote1_disparity <- boot.matrix(Amniote1_disparity,bootstraps = 1000)
Amniote1_disparity <- dispRity(Amniote1_disparity,metric = c(sum,variances))

test.dispRity(Amniote1_disparity,test = wilcox.test,correction = 'bonferroni')

Amniote2 <- lapply ( sort(unique(dat$H2_A)), function(x) rownames(dat)[dat$H2_A==x]  )
names(Amniote2) <- sort(unique(dat$H2_A))

Amniote2 <- Amniote2[c('Amniote','Non-amniote')]

Amniote2_disparity <- custom.subsets(pca$x,group = Amniote2)
Amniote2_disparity <- boot.matrix(Amniote2_disparity,bootstraps = 1000)
Amniote2_disparity <- dispRity(Amniote2_disparity,metric = c(sum,variances))

test.dispRity(Amniote2_disparity,test = wilcox.test,correction = 'bonferroni')

Amniote3 <- lapply ( sort(unique(dat$H3_A)), function(x) rownames(dat)[dat$H3_A==x]  )
names(Amniote3) <- sort(unique(dat$H3_A))

Amniote3 <- Amniote3[c('Amniote','Non-amniote')]

Amniote3_disparity <- custom.subsets(pca$x,group = Amniote3)
Amniote3_disparity <- boot.matrix(Amniote3_disparity,bootstraps = 1000)
Amniote3_disparity <- dispRity(Amniote3_disparity,metric = c(sum,variances))

test.dispRity(Amniote3_disparity,test = wilcox.test,correction = 'bonferroni')

Amniote4 <- lapply ( sort(unique(dat$H4_A)), function(x) rownames(dat)[dat$H4_A==x]  )
names(Amniote4) <- sort(unique(dat$H4_A))

Amniote4 <- Amniote4[c('Amniote','Non-amniote')]

Amniote4_disparity <- custom.subsets(pca$x,group = Amniote4)
Amniote4_disparity <- boot.matrix(Amniote4_disparity,bootstraps = 1000)
Amniote4_disparity <- dispRity(Amniote4_disparity,metric = c(sum,variances))

test.dispRity(Amniote4_disparity,test = wilcox.test,correction = 'bonferroni')

dev.off()
dev.new()
par(mfrow=c(2,2), pin = c(4, 3))

plot(Amniote1_disparity, col = c('darkgoldenrod','lightgoldenrod'))
plot(Amniote2_disparity, col = c('darkgoldenrod','lightgoldenrod'))
plot(Amniote3_disparity, col = c('darkgoldenrod','lightgoldenrod'))
plot(Amniote4_disparity, col = c('darkgoldenrod','lightgoldenrod'))

#SynSaur

set.seed(25)

SynSaur1 <- lapply ( sort(unique(dat$H1_SynSaur)), function(x) rownames(dat)[dat$H1_SynSaur==x]  )
names(SynSaur1) <- sort(unique(dat$H1_SynSaur))

SynSaur1 <- SynSaur1[c('Non-amniote', 'Sauropsida','Synapsida')]

SynSaur1_disparity <- custom.subsets(pca$x,group = SynSaur1)
SynSaur1_disparity <- boot.matrix(SynSaur1_disparity,bootstraps = 1000)
SynSaur1_disparity <- dispRity(SynSaur1_disparity,metric = c(sum,variances))

test.dispRity(SynSaur1_disparity,test = wilcox.test,correction = 'bonferroni')

SynSaur2 <- lapply ( sort(unique(dat$H2_SynSaur)), function(x) rownames(dat)[dat$H2_SynSaur==x]  )
names(SynSaur2) <- sort(unique(dat$H2_SynSaur))

SynSaur2 <- SynSaur2[c('Non-amniote', 'Sauropsida','Synapsida')]

SynSaur2_disparity <- custom.subsets(pca$x,group = SynSaur2)
SynSaur2_disparity <- boot.matrix(SynSaur2_disparity,bootstraps = 1000)
SynSaur2_disparity <- dispRity(SynSaur2_disparity,metric = c(sum,variances))

test.dispRity(SynSaur2_disparity,test = wilcox.test,correction = 'bonferroni')

SynSaur3 <- lapply ( sort(unique(dat$H3_SynSaur)), function(x) rownames(dat)[dat$H3_SynSaur==x]  )
names(SynSaur3) <- sort(unique(dat$H3_SynSaur))

SynSaur3 <- SynSaur3[c('Non-amniote', 'Sauropsida','Synapsida')]

SynSaur3_disparity <- custom.subsets(pca$x,group = SynSaur3)
SynSaur3_disparity <- boot.matrix(SynSaur3_disparity,bootstraps = 1000)
SynSaur3_disparity <- dispRity(SynSaur3_disparity,metric = c(sum,variances))

test.dispRity(SynSaur3_disparity,test = wilcox.test,correction = 'bonferroni')

SynSaur4 <- lapply ( sort(unique(dat$H4_SynSaur)), function(x) rownames(dat)[dat$H4_SynSaur==x]  )
names(SynSaur4) <- sort(unique(dat$H4_SynSaur))

SynSaur4 <- SynSaur4[c('Non-amniote', 'Sauropsida','Synapsida')]

SynSaur4_disparity <- custom.subsets(pca$x,group = SynSaur4)
SynSaur4_disparity <- boot.matrix(SynSaur4_disparity,bootstraps = 1000)
SynSaur4_disparity <- dispRity(SynSaur4_disparity,metric = c(sum,variances))

test.dispRity(SynSaur4_disparity,test = wilcox.test,correction = 'bonferroni')

dev.off()
dev.new()
par(mfrow=c(2,2), pin = c(4, 3))

plot(SynSaur1_disparity, col = c('lightgoldenrod','chartreuse','deepskyblue'))
plot(SynSaur2_disparity, col = c('lightgoldenrod','chartreuse','deepskyblue'))
plot(SynSaur3_disparity, col = c('lightgoldenrod','chartreuse','deepskyblue'))
plot(SynSaur4_disparity, col = c('lightgoldenrod','chartreuse','deepskyblue'))

#Herbs vs. nonherbs

set.seed(25)

Herb <- lapply ( sort(unique(dat$Herb)), function(x) rownames(dat)[dat$Herb==x]  )
names(Herb) <- sort(unique(dat$Herb))

Herb <- Herb[c('Herbivore','Non-herbivore')]

Herb_disparity <- custom.subsets(pca$x,group = Herb)
Herb_disparity <- boot.matrix(Herb_disparity,bootstraps = 1000)
Herb_disparity <- dispRity(Herb_disparity,metric = c(sum,variances))

test.dispRity(Herb_disparity,test = wilcox.test,correction = 'bonferroni')

plot(Herb_disparity, col = c('darkolivegreen','firebrick'))

#Separation of morphospace occupation (centroids)#####

set.seed(25)

#Amniotes vs. non-amniotes
#H1
group_data <- read.table("group_amniote_H1.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#H2
group_data <- read.table("group_amniote_H2.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#H3
group_data <- read.table("group_amniote_H3.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#H4
group_data <- read.table("group_amniote_H4.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Amniotes <- row.names(group_data)[group_data[,1] == 'Amniote']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#SynSaur

set.seed(25)

#H1
group_data <- read.table("group_synsaur_H1.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Synapsida <- row.names(group_data)[group_data[,1] == 'Synapsida']
Sauropsida <- row.names(group_data)[group_data[,1] == 'Sauropsida']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#H2
group_data <- read.table("group_synsaur_H2.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Synapsida <- row.names(group_data)[group_data[,1] == 'Synapsida']
Sauropsida <- row.names(group_data)[group_data[,1] == 'Sauropsida']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#H3
group_data <- read.table("group_synsaur_H3.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Synapsida <- row.names(group_data)[group_data[,1] == 'Synapsida']
Sauropsida <- row.names(group_data)[group_data[,1] == 'Sauropsida']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#H4
group_data <- read.table("group_synsaur_H4.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Synapsida <- row.names(group_data)[group_data[,1] == 'Synapsida']
Sauropsida <- row.names(group_data)[group_data[,1] == 'Sauropsida']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#Herbivores vs. non-herbivores

set.seed(25)

group_data <- read.table("group_herb.txt", row.names=1, header=T)
Nonherbivores <- row.names(group_data)[group_data[,1] == 'Non-herbivore']
Herbivores <- row.names(group_data)[group_data[,1] == 'Herbivore'] 
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#Faunivorous amniotes vs. non-amniote tetrapods

set.seed(25)

group_data <- read.table("group_amniote_carn.txt", row.names=1, header=T)
Nonamniotes <- row.names(group_data)[group_data[,1] == 'Non-amniote']
Faunivorousamniotes <- row.names(group_data)[group_data[,1] == 'Amniote_carn']
Herbivorousamniotes <- row.names(group_data)[group_data[,1] == 'Amniote_herb']
group_factors <- as.vector(group_data[,1])
names(group_factors) <- row.names(group_data)
PERMANOVA.results <- pairwise.adonis(pca$x, factors=group_factors, sim.method = 'euclidean', p.adjust.m ='bonferroni')
PERMANOVA.results

#Morphospace per time bin#######
dev.off()
dev.new()
par(mfrow=c(5,1), pin = c(2, 1))

#H1
plot(pca$x[,1:2],
     
     pch=c(21,22,22) [as.numeric(as.factor(dat$H1_SynSaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H1_SynSaur))], 
     cex=ifelse(dat$Lopingian=='Lopingian',1.5,0)
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H1_SynSaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H1_SynSaur))], 
     cex=ifelse(dat$Guadalupian=='Guadalupian',1.5,0)
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H1_SynSaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H1_SynSaur))]
     , cex=ifelse(dat$Cisuralian=='Cisuralian',1.5,0)
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H1_SynSaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H1_SynSaur))], 
     cex=ifelse(dat$Pennsylvanian=='Pennsylvanian',1.5,0)
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

plot(pca$x[,1:2], 
     pch=c(21,22,22) [as.numeric(as.factor(dat$H1_SynSaur))], 
     bg=c('lightgoldenrod','chartreuse','deepskyblue') [as.numeric(as.factor(dat$H1_SynSaur))],
    cex=ifelse(dat$Mississippian=='Mississippian',1.5,0)
)
abline(h = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)
abline(v = 0, col = rgb(0.5, 0.5, 0.5, 0.5), lty = 2, lwd = 1)

#Disparity through time #######
dev.off()
dev.new()

bin_ranges <- read.table("bin_ranges_epoch.txt", header=T, row.names=1)
taxon_ages <- read.table ("taxon_ages.txt", row.names=1, header=T)
taxon_ages <- as.data.frame(taxon_ages[rownames(pca$x),])
taxon_ages

time.bins <- list()
for (i in 1:length(rownames(bin_ranges))) {time.bins[[i]] <- rownames(taxon_ages)[which(taxon_ages$FAD > bin_ranges[i,"min.age"] & taxon_ages$LAD < bin_ranges[i,"max.age"])]}
names(time.bins) <- rownames(bin_ranges)
time.bins 

bin_PA <-  matrix(0, nrow=nrow(pca$x), ncol=length(time.bins))
rownames(bin_PA) <- rownames(pca$x)
bin_PA

for(x in 1:length(time.bins)) {
  taxaInHere <- match(time.bins [[x]], rownames(bin_PA))
  bin_PA[taxaInHere, x] <- 1
}

bin_PA #Useful overview of taxa per time bin

sov_disparity <- DtT (pca$x, bin_PA, 1000)

sov_results_mean <- sov_disparity$Variance[1,]
sov_results_lower <- c(sov_disparity$Variance[1,]- sov_disparity$Variance[2,])
sov_results_upper <- c(sov_disparity$Variance[1,] +sov_disparity$Variance[2,])

sov_results_final_time <- data.frame(sov_results_mean, sov_results_lower, sov_results_upper)
colnames(sov_results_final_time) <- c("mean","lower","upper")
rownames(sov_results_final_time) <- names(time.bins)
sov_results_final_time

results_plot <- sov_results_final_time

#Create limits which will denote the time bins
midpoints <- rowMeans(bin_ranges)
nbins <- nrow(bin_ranges)

# set-up the plotting area
layout (matrix (1:1, 2, 1))
upper.y <- 1.2 * max (results_plot [, "upper"])
lower.y <- 0.8 * min (results_plot [, "lower"])
upper.CI <- results_plot[, "upper"]
lower.CI <- results_plot [, "lower"]
x.limits <- c(max(bin_ranges), min(bin_ranges))
y.limits <- c(lower.y*1.1, upper.y*0.9 )

# plot empty graph with time bins
plot (midpoints, y = results_plot [, "mean"], xlim = x.limits, ylim = y.limits, col = "transparent", xlab = "age (Ma)", ylab = "Disparity (sum of variances)", cex=1.2)
# plot time slices as shaded area
polygon (c(346.7, 330.9, 330.9, 346.7), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(323.2, 315.2, 315.2, 323.2), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(307.0, 303.7,303.7, 307.0), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(298.9, 293.52, 293.52, 298.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(290.1, 283.5, 283.5, 290.1), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(273.01, 266.9,266.9, 273.01), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(264.28, 259.51,259.51,264.28), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(254.14, 251.9,251.9, 254.14), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))

abline(v=251.9)
abline(v=346.7)

# plot disparity data (all taxa)
nbins<-nrow(bin_ranges)
polygon (c(midpoints, midpoints [nbins:1]), y = c(lower.CI, upper.CI [nbins:1]), border = NA, col = "lightblue")
lines (midpoints, y = results_plot [, "mean"])
points (midpoints, results_plot [, "mean"], pch = 21, col = "black", bg = "white", cex=1.3, lwd=1.4)

#plot disparity data (amniotes vs. non-amniotes)
layout (matrix (1:1, 2, 1))
upper.y <- 1.2 * max (results_plot [, "upper"])
lower.y <- 0.8 * min (results_plot [, "lower"])
upper.CI <- results_plot[, "upper"]
lower.CI <- results_plot [, "lower"]
x.limits <- c(max(bin_ranges), min(bin_ranges))
y.limits <- c(lower.y*1.1, upper.y*0.9 )

# plot empty graph with time bins
plot (midpoints, y = results_plot [, "mean"], xlim = x.limits, ylim = y.limits, col = "transparent", xlab = "age (Ma)", ylab = "Disparity (sum of variances)", cex=1.2)
# plot time slices as shaded area
polygon (c(346.7, 330.9, 330.9, 346.7), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(323.2, 315.2, 315.2, 323.2), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(307.0, 303.7,303.7, 307.0), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(298.9, 293.52, 293.52, 298.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(290.1, 283.5, 283.5, 290.1), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(273.01, 266.9,266.9, 273.01), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(264.28, 259.51,259.51,264.28), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(254.14, 251.9,251.9, 254.14), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))

abline(v=251.9)
abline(v=346.7)

#Non-amniote disparity plot (H2)
nbins<-nrow(bin_ranges)
bin_PA_df <- as.data.frame(bin_PA, stringsAsFactors = FALSE)
bin_PA_df$Amniote <- dat$H2_A
bin_PA_nonamniote <- bin_PA_df %>% filter(Amniote != "Amniote")    
bin_PA_nonamniote <- bin_PA_nonamniote[,-16]   

pca_nonamniote <- as.data.frame(pca$x)
pca_nonamniote$Amniote <- dat$H2_A
pca_nonamniote <- pca_nonamniote %>% filter(Amniote != "Amniote")
pca_nonamniote <- pca_nonamniote[,-10]   

sov_disparity_nonamniote <- DtT (pca_nonamniote, bin_PA_nonamniote, 1000)

sov_results_mean_nonamniote <- sov_disparity_nonamniote$Variance[1,]
sov_results_lower_nonamniote <- c(sov_disparity_nonamniote$Variance[1,]- sov_disparity_nonamniote$Variance[2,])
sov_results_upper_nonamniote <- c(sov_disparity_nonamniote$Variance[1,] +sov_disparity_nonamniote$Variance[2,])

sov_results_final_time_nonamniote <- data.frame(sov_results_mean_nonamniote, sov_results_lower_nonamniote, sov_results_upper_nonamniote)
colnames(sov_results_final_time_nonamniote) <- c("mean","lower","upper")
rownames(sov_results_final_time_nonamniote) <- names(time.bins)
sov_results_final_time_nonamniote

results_plot_nonamniote <- sov_results_final_time_nonamniote

midpoints_nonamniote <- rowMeans(bin_ranges)
nbins <- nrow(bin_ranges)

nbins<-nrow(bin_ranges)
lines (midpoints_nonamniote, y = results_plot_nonamniote [, "mean"],lty = 2)
points (midpoints_nonamniote, results_plot_nonamniote [, "mean"], pch = 21, col = "black", bg = "white", cex=1.3, lwd=1.4)

#Amniote disparity plot (H2)
nbins<-nrow(bin_ranges)
bin_PA_df <- as.data.frame(bin_PA, stringsAsFactors = FALSE)
bin_PA_df$Amniote <- dat$H2_A
bin_PA_amniote <- bin_PA_df %>% filter(Amniote != "Non-amniote")    
bin_PA_amniote <- bin_PA_amniote[,-16]   

pca_amniote <- as.data.frame(pca$x)
pca_amniote$Amniote <- dat$H2_A
pca_amniote <- pca_amniote %>% filter(Amniote != "Non-amniote")
pca_amniote <- pca_amniote[,-10]   

sov_disparity_amniote <- DtT (pca_amniote, bin_PA_amniote, 1000)

sov_results_mean_amniote <- sov_disparity_amniote$Variance[1,]
sov_results_lower_amniote <- c(sov_disparity_amniote$Variance[1,]- sov_disparity_amniote$Variance[2,])
sov_results_upper_amniote <- c(sov_disparity_amniote$Variance[1,] +sov_disparity_amniote$Variance[2,])

sov_results_final_time_amniote <- data.frame(sov_results_mean_amniote, sov_results_lower_amniote, sov_results_upper_amniote)
colnames(sov_results_final_time_amniote) <- c("mean","lower","upper")
rownames(sov_results_final_time_amniote) <- names(time.bins)
sov_results_final_time_amniote

results_plot_amniote <- sov_results_final_time_amniote

midpoints_amniote <- rowMeans(bin_ranges)
nbins <- nrow(bin_ranges)

nbins<-nrow(bin_ranges)
lines (midpoints_amniote, y = results_plot_amniote [, "mean"])
points (midpoints_amniote, results_plot_amniote [, "mean"], pch = 21, col = "black", bg = "white", cex=1.3, lwd=1.4)

#plot disparity data (herbivores vs. non-herbivores)
layout (matrix (1:1, 2, 1))
upper.y <- 1.2 * max (results_plot [, "upper"])
lower.y <- 0.8 * min (results_plot [, "lower"])
upper.CI <- results_plot[, "upper"]
lower.CI <- results_plot [, "lower"]
x.limits <- c(max(bin_ranges), min(bin_ranges))
y.limits <- c(lower.y*1.1, upper.y*0.9 )

# plot empty graph with time bins
plot (midpoints, y = results_plot [, "mean"], xlim = x.limits, ylim = y.limits, col = "transparent", xlab = "age (Ma)", ylab = "Disparity (sum of variances)", cex=1.2)
# plot time slices as shaded area
polygon (c(346.7, 330.9, 330.9, 346.7), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(323.2, 315.2, 315.2, 323.2), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(307.0, 303.7,303.7, 307.0), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(298.9, 293.52, 293.52, 298.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(290.1, 283.5, 283.5, 290.1), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(273.01, 266.9,266.9, 273.01), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(264.28, 259.51,259.51,264.28), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(254.14, 251.9,251.9, 254.14), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))

abline(v=251.9)
abline(v=346.7)

#Non-herbs
nbins<-nrow(bin_ranges)
bin_PA_df <- as.data.frame(bin_PA, stringsAsFactors = FALSE)
bin_PA_df$Herb <- dat$Herb
bin_PA_nonherb <- bin_PA_df %>% filter(Herb != "Herbivore")    
bin_PA_nonherb <- bin_PA_nonherb[,-16]   

pca_nonherb <- as.data.frame(pca$x)
pca_nonherb$Herb <- dat$Herb
pca_nonherb <- pca_nonherb %>% filter(Herb != "Herbivore")
pca_nonherb <- pca_nonherb[,-10]   

sov_disparity_nonherb <- DtT (pca_nonherb, bin_PA_nonherb, 1000)

sov_results_mean_nonherb <- sov_disparity_nonherb$Variance[1,]
sov_results_lower_nonherb <- c(sov_disparity_nonherb$Variance[1,]- sov_disparity_nonherb$Variance[2,])
sov_results_upper_nonherb <- c(sov_disparity_nonherb$Variance[1,] +sov_disparity_nonherb$Variance[2,])

sov_results_final_time_nonherb <- data.frame(sov_results_mean_nonherb, sov_results_lower_nonherb, sov_results_upper_nonherb)
colnames(sov_results_final_time_nonherb) <- c("mean","lower","upper")
rownames(sov_results_final_time_nonherb) <- names(time.bins)
sov_results_final_time_nonherb

results_plot_nonherb <- sov_results_final_time_nonherb

midpoints_nonherb <- rowMeans(bin_ranges)
nbins <- nrow(bin_ranges)

nbins<-nrow(bin_ranges)
lines (midpoints_nonherb, y = results_plot_nonherb [, "mean"],lty=2)
points (midpoints_nonherb, results_plot_nonherb [, "mean"], pch = 21, col = "black", bg = "white", cex=1.3, lwd=1.4)

#Number of specimens per time bin #####
layout (matrix (1:1, 2, 1))
upper.y <- 40
lower.y <- 0
upper.CI <- results_plot[, "upper"]
lower.CI <- results_plot [, "lower"]
x.limits <- c(max(bin_ranges), min(bin_ranges))
y.limits <- c(lower.y*1, upper.y*1)

plot (midpoints, y = results_plot [, "mean"], xlim = x.limits, ylim = y.limits, col = "transparent", xlab = "age (Ma)", ylab = "No. specimens", cex=1.2)
# plot time slices as shaded area
polygon (c(346.7, 330.9, 330.9, 346.7), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(323.2, 315.2, 315.2, 323.2), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(307.0, 303.7,303.7, 307.0), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(298.9, 293.52, 293.52, 298.9), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(290.1, 283.5, 283.5, 290.1), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(273.01, 266.9,266.9, 273.01), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(264.28, 259.51,259.51,264.28), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))
polygon (c(254.14, 251.9,251.9, 254.14), y = c(-1000, -1000, 3000, 3000), border = NA, col = rgb (0, 0, 0, 0.06))

#Amniotes vs. non-amniotes (change H1 (base) to H2, H3 or H4)
nbins<-nrow(bin_ranges)
bin_alphadiversity <- colSums(bin_PA)

bin_PA_df <- as.data.frame(bin_PA, stringsAsFactors = FALSE)
bin_PA_df$Amniote <- dat$H1_A

bin_PA_amniote <- bin_PA_df %>% filter(Amniote != "Non-amniote")    
bin_PA_amniote <- bin_PA_amniote[,-16]   
bin_amniote <- colSums(bin_PA_amniote)

bin_PA_nonamniote <- bin_PA_df %>% filter(Amniote != "Amniote")    
bin_PA_nonamniote <- bin_PA_nonamniote[,-16]   
bin_nonamniote <- colSums(bin_PA_nonamniote)

lines (midpoints, y = bin_alphadiversity, lwd=2)
textpoint <- max(bin_alphadiversity)*1.04

lines (midpoints, y = bin_amniote, lwd = 0.5)
lines (midpoints, y = bin_nonamniote, lwd = 0.5, lty = 2)

#Partial disparity#####

dev.off()
dev.new()

partial.disparity <- function(X,groups){ #Partial disparity (as fraction)
  centroid <- colMeans(X)
  pd <- as.matrix(dist(rbind(X,centroid)))[1:nrow(X),-(1:ncol(X))]^2 / (nrow(X)-1)
  sapply(split(pd,groups),sum)
}

partial.disparity.as.percentage <- function(X,groups){ #Partial disparity (as percentage)
  centroid <- colMeans(X)
  pd <- as.matrix(dist(rbind(X,centroid)))[1:nrow(X),-(1:ncol(X))]^2 / (nrow(X)-1)
  sapply(split(pd,groups),sum)*100/sum(pd)
}

#Change H1 (base) to H2, H3 or H4
ages <- read.table("taxon_ages.txt",sep="\t",head=TRUE) 
epoch <- read.table("bin_ranges_epoch.txt",sep="\t",head=TRUE)
dat$Clade <- as.factor(dat$H1_SynSaur) 
pd_through_t <- matrix(NA,nrow=nlevels(dat$Clade),ncol=nrow(epoch)) #Clade partial disparity per time bin
pd_through_t_perc <- matrix(NA,nrow=nlevels(dat$Clade),ncol=nrow(epoch))

rownames(pd_through_t) <- rownames(pd_through_t_perc) <- levels(dat$Clade)
colnames(pd_through_t) <- colnames(pd_through_t_perc) <- epoch[,1]

for(i in seq_along(epoch$Stage)){
  dat_stage <- dat[ages$FAD>=epoch$min.age[i]&ages$LAD<=epoch$max.age[i],] 
  pca_stage <- prcomp(dat_stage[,1:9],scale. = T)
  pd_through_t_perc[,i] <- partial.disparity.as.percentage(pca_stage$x,dat_stage$Clade)
}

pd_through_t_perc

stratplot <- function(xlim){
  load("ics2023.Rdata")
  plot(NA,xaxs="i",yaxs="i",xlim=xlim,ylim=c(0,3),ax=FALSE,ann=FALSE)
  period <- ics[ics$Type=="Period",]
  for(i in 1:nrow(period)){
    rect(period$Start[i]/1e6,0,period$End[i]/1e6,1,col=period$Color[i])
    text((period$Start[i]/1e6+period$End[i]/1e6)/2,.5,period$Name[i])
  }
  stage <- ics[ics$Type=="Stage",]
  stage$Name <- gsub(" .+$","",stage$Name)
  for(i in 1:nrow(stage)){
    rect(stage$Start[i]/1e6,1,stage$End[i]/1e6,3,col=stage$Color[i])
    text((stage$Start[i]/1e6+stage$End[i]/1e6)/2,2,stage$Name[i],cex=1,srt=90)
  }
  box(lwd=1.5)
  axis(1,cex.axis=0.7,at=seq(0,350,1),labels=FALSE)
  axis(1,cex.axis=0.7,at=seq(0,350,5),labels=FALSE,lwd=1.5)
  axis(1,cex.axis=1,at=seq(0,350,10),lwd=1.5)
  mtext("Age (Ma)",1,2.5,cex=1)
}

#Plots

cols <- c('lightgoldenrod','chartreuse','deepskyblue')
layout(matrix(1:2,ncol=1),height=c(2,1))
par(mar=c(0,5,1,5))
plot(NA,xlim=c(346.7,252.2),ylim=c(0,100),xaxs="i",yaxs="i",ann=FALSE,ax=FALSE)
pl <- cbind(c(100,0,0,0,0),pd_through_t_perc,pd_through_t_perc[,ncol(pd_through_t_perc)])
midp <- c(346.7,apply(epoch[,2:3],1,mean),252.2)
pl <- apply(pl,2,cumsum)
for(i in 1:nrow(pl)){
  if(i==1){
    polygon(c(midp,252.2,346.7),c(pl[i,],0,0),col=cols[i])
  }else{
    polygon(c(midp,rev(midp)),c(pl[i,],rev(pl[i-1,])),col=cols[i])
  }
}
axis(2,at=c(0,25,50,75,100),labels=c("0","0.25","0.5","0.75","1"),las=2)
box(lwd=2)

par(mar=c(5,5,0,5))
stratplot(xlim=c(346.7,252.2))

#Partial disparity herbivores vs carnivores
dev.off()
dev.new()

partial.disparity <- function(X,groups){ #Partial disparity (as fraction)
  centroid <- colMeans(X)
  pd <- as.matrix(dist(rbind(X,centroid)))[1:nrow(X),-(1:ncol(X))]^2 / (nrow(X)-1)
  sapply(split(pd,groups),sum)
}

partial.disparity.as.percentage <- function(X,groups){ #Partial disparity (as percentage)
  centroid <- colMeans(X)
  pd <- as.matrix(dist(rbind(X,centroid)))[1:nrow(X),-(1:ncol(X))]^2 / (nrow(X)-1)
  sapply(split(pd,groups),sum)*100/sum(pd)
}

ages <- read.table("taxon_ages.txt",sep="\t",head=TRUE) 
epoch <- read.table("bin_ranges_epoch.txt",sep="\t",head=TRUE)
dat$Herb <- as.factor(dat$Herb) 
pd_through_t <- matrix(NA,nrow=nlevels(dat$Herb),ncol=nrow(epoch)) #Diet partial disparity per time bin
pd_through_t_perc <- matrix(NA,nrow=nlevels(dat$Herb),ncol=nrow(epoch))

rownames(pd_through_t) <- rownames(pd_through_t_perc) <- levels(dat$Herb)
colnames(pd_through_t) <- colnames(pd_through_t_perc) <- epoch[,1]

for(i in seq_along(epoch$Stage)){
  dat_stage <- dat[ages$FAD>=epoch$min.age[i]&ages$LAD<=epoch$max.age[i],] 
  pca_stage <- prcomp(dat_stage[,1:9],scale. = T)
  pd_through_t_perc[,i] <- partial.disparity.as.percentage(pca_stage$x,dat_stage$Herb)
}

pd_through_t_perc

stratplot <- function(xlim){
  load("ics2023.Rdata")
  plot(NA,xaxs="i",yaxs="i",xlim=xlim,ylim=c(0,3),ax=FALSE,ann=FALSE)
  period <- ics[ics$Type=="Period",]
  for(i in 1:nrow(period)){
    rect(period$Start[i]/1e6,0,period$End[i]/1e6,1,col=period$Color[i])
    text((period$Start[i]/1e6+period$End[i]/1e6)/2,.5,period$Name[i])
  }
  stage <- ics[ics$Type=="Stage",]
  stage$Name <- gsub(" .+$","",stage$Name)
  for(i in 1:nrow(stage)){
    rect(stage$Start[i]/1e6,1,stage$End[i]/1e6,3,col=stage$Color[i])
    text((stage$Start[i]/1e6+stage$End[i]/1e6)/2,2,stage$Name[i],cex=1,srt=90)
  }
  box(lwd=1.5)
  axis(1,cex.axis=0.7,at=seq(0,350,1),labels=FALSE)
  axis(1,cex.axis=0.7,at=seq(0,350,5),labels=FALSE,lwd=1.5)
  axis(1,cex.axis=1,at=seq(0,350,10),lwd=1.5)
  mtext("Age (Ma)",1,2.5,cex=1)
}

#Plots

cols <- c('darkolivegreen','firebrick')
layout(matrix(1:2,ncol=1),height=c(2,1))
par(mar=c(0,5,1,5))
plot(NA,xlim=c(346.7,252.2),ylim=c(0,100),xaxs="i",yaxs="i",ann=FALSE,ax=FALSE)
pl <- cbind(c(100,0,0,0,0),pd_through_t_perc,pd_through_t_perc[,ncol(pd_through_t_perc)])
midp <- c(346.7,apply(epoch[,2:3],1,mean),252.2)
pl <- apply(pl,2,cumsum)
for(i in 1:nrow(pl)){
  if(i==1){
    polygon(c(midp,252.2,346.7),c(pl[i,],0,0),col=cols[i])
  }else{
    polygon(c(midp,rev(midp)),c(pl[i,],rev(pl[i-1,])),col=cols[i])
  }
}
axis(2,at=c(0,25,50,75,100),labels=c("0","0.25","0.5","0.75","1"),las=2)
box(lwd=2)

par(mar=c(5,5,0,5))
stratplot(xlim=c(346.7,252.2))

